<?php
namespace NinjaForms\CfConversionTool;

use NinjaForms\CfConversionTool\Master;
use NinjaForms\CfConversionTool\Bootstraps\InitLate;

$autoload = autoloader(__FILE__);

if (!$autoload) {
    return;
}

/** 
 * Hook bootstrapping function to the initializing action hook
 */
add_action('cf_conversion_tool_init', 'NinjaForms\CfConversionTool\bootstrap', 5);

/**
 * Instantiate the master class, set root directory, and register services
 */
$master = new Master();

/**
 * Call the initializing action hook and pass in the instantiated master class
 */
do_action('cf_conversion_tool_init', $master);


/**
 * Master bootstrap file
 * 
 * ### Bootstrapping Steps: ###
 * 1. Include the autoloader automatically generated by the composer PSR-4
 *    specification
 * 2. Hook the bootstrapping function to the main initializing hook
 * 3. Instantiate the master class, set its root directory, and register
 *    services
 * 4. Pass the instantiated class into the initializing hook, where the main
 *    bootstrapping occurs, and other functionality can extend the core
 *    functionality
 * 
 * @package Initializing
 *
 * @param Master $master
 * @return void
 */
function bootstrap($master)
{
    /** @var Master $master */


    /**
     * Hook the InitLate class functionality
     */
    add_action('init', function () use ($master) {
        new InitLate($master);
    }, 15);
};


/**
 * Load an autoloader from vendor subdirectory
 *
 * This function can be copied and reused in other plugins using composer's
 * PSR-4 specification because it is namespaced within this file to avoid
 * collision.
 *
 * @return boolean
 */
function autoloader(string $rootFileLocation): bool
{
    $autoloader = dirname($rootFileLocation) . '/vendor/autoload.php';

    if (file_exists($autoloader)) {
        include_once $autoloader;
        $return = true;
    } else {
        $return = false;
    }
    return $return;
}
